/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:0*/
layout(location = 0) out vec3 sceneGraded;

#include "/lib/head.glsl"
#include "/lib/util/colorspace.glsl"

#define INFO 0  //[0]

/* ------ color grading related settings ------ */
//#define do_colorgrading

#define vibranceInt 1.00       //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define saturationInt 1.00     //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define gammaCurve 1.00        //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define brightnessInt 0.00     //[-0.50 -0.45 -0.40 -0.35 -0.30 -0.25 -0.20 -0.15 -0.10 -0.05 0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.5]
#define constrastInt 1.00      //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]

#define colorlumR 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define colorlumG 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]
#define colorlumB 1.00         //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00]

#define vignetteEnabled
#define vignetteStart 0.15     //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignetteEnd 0.75       //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignetteIntensity 0.80 //[0.00 0.05 0.10 0.15 0.20 0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00]
#define vignetteExponent 1.75  //[0.50 0.75 1.0 1.25 1.50 1.75 2.00 2.25 2.50 2.75 3.00 3.25 3.50 3.75 4.00 4.25 4.50 4.75 5.00]

in vec2 coord;

uniform sampler2D colortex0;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;

uniform int frameCounter;
uniform int isEyeInWater;

uniform float frameTimeCounter;
uniform float nightVision;

uniform vec2 bloomResolution;
uniform vec2 pixelSize;
uniform vec2 viewSize;

/* ------ tonemapping operators ------ */

vec3 tonemapReinhard(vec3 hdr) {
    float luma      = getLuma(hdr);

    float coeff     = 0.9 - nightVision*0.7;

    vec3 col        = hdr/(hdr + coeff);
        col         = mix(hdr/(luma + coeff), col, col);

    return LinearToSRGB(col);
}

vec3 tonemapHejlBurgess(vec3 hdr) {
    hdr    *= 0.75;
    vec3 x     = max(hdr - 0.004, 0.0);    
    return (x * (6.2 * x + 0.5)) * rcp(x * (6.2 * x + 1.7) + 0.06);
}

#include "/lib/frag/academy/aces.glsl"

/* ------ color grading utilities ------ */

vec3 rgbLuma(vec3 x) {
    return x * vec3(colorlumR, colorlumG, colorlumB);
}

vec3 applyGammaCurve(vec3 x) {
    return pow(x, vec3(gammaCurve));
}

vec3 vibranceSaturation(vec3 color) {
    float lum   = dot(color, lumacoeff_rec709);
    float mn    = min(min(color.r, color.g), color.b);
    float mx    = max(max(color.r, color.g), color.b);
    float sat   = (1.0 - saturate(mx-mn)) * saturate(1.0-mx) * lum * 5.0;
    vec3 light  = vec3((mn + mx) / 2.0);

    color   = mix(color, mix(light, color, vibranceInt), saturate(sat));

    color   = mix(color, light, saturate(1.0-light) * (1.0-vibranceInt) / 2.0 * abs(vibranceInt));

    color   = mix(vec3(lum), color, saturationInt);

    return color;
}

vec3 brightnessContrast(vec3 color) {
    return (color - 0.5) * constrastInt + 0.5 + brightnessInt;
}

vec3 vignette(vec3 color) {
    float fade      = length(coord*2.0-1.0);
        fade        = linStep(abs(fade) * 0.5, vignetteStart, vignetteEnd);
        fade        = 1.0 - pow(fade, vignetteExponent) * vignetteIntensity;

    return color * fade;
}

#ifdef legacyFlareToggle
uniform float aspectRatio;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 sunvec;
uniform vec4 daytime;
uniform mat4 gbufferProjection;

uniform sampler2D depthtex1;

#include "/lib/frag/bslflare.glsl"

vec3 getLensflare(){
    vec3 sunlightSunrise;
        sunlightSunrise.r   = 0.79;
        sunlightSunrise.g   = 0.306;
        sunlightSunrise.b   = 0.03;
        sunlightSunrise    *= 0.7;

    vec3 sunlightNoon;
        sunlightNoon.r      = 1.0;
        sunlightNoon.g      = 0.93;
        sunlightNoon.b      = 0.72;
        sunlightNoon       *= 1.0;

    vec3 sunlightSunset;
        sunlightSunset.r    = 0.79;
        sunlightSunset.g    = 0.29;
        sunlightSunset.b    = 0.04;
        sunlightSunset     *= 0.7;

    vec3 sunlightNight;
        sunlightNight.r     = 0.69;
        sunlightNight.g     = 0.27;
        sunlightNight.b     = 0.04;
        sunlightNight      *= 0.1;

    vec3 sunColor           = sunlightSunrise*daytime.x + sunlightNoon*daytime.y + sunlightSunset*daytime.z + sunlightNight*daytime.w;
        sunColor           *= 16.0 * sunlightIllum;

	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
        tpos.xyz /= tpos.w;
        tpos.xy = tpos.xy/tpos.z;

	vec2 lightPos = tpos.xy * 0.5;
	float truepos = sunPosition.z/abs(sunPosition.z);
	vec3 visible = vec3(!landMask(texture(depthtex1, lightPos.xy + 0.5).r));
        visible *= sstep(sunvec.y, 0.0, 0.1);

        visible *= 1.0-linStep(length(tpos.xy), 0.85, 1.25);

    if(min(visible.x, min(visible.y, visible.z))>0.01 && truepos < 1.0) {
        return genLensFlare(lightPos, truepos, 1.0) * sunColor * 0.75 * legacyFlareIntensity;
    } else {
        return vec3(0.0);
    }
}
#endif

void main() {
    vec3 sceneHDR   = stex(colortex0).rgb;

    #ifdef bloomEnabled
        vec2 cres       = max(viewSize, bloomResolution);

        float bloomInt = 0.14 /*+ max(stex(colortex4).a, 1.0)*0.0088*/;

        #if DIM == -1
            bloomInt   = 0.5;
        #elif DIM == 1
            bloomInt  *= 1.5;
        #endif

        if (isEyeInWater == 1) bloomInt = mix(bloomInt, 1.0, 0.4);

        vec3 bloom  = texture(colortex3, coord/cres*bloomResolution*0.5).rgb * 4.0;  //apply bloom

        sceneHDR    = mix(sceneHDR, bloom * 1.3, saturate(bloomInt));

        float rint      = stex(colortex2).y;
        bool rain       = rint > 0.0;

        if (rain) sceneHDR = mix(sceneHDR, bloom * 1.4, rint * 0.5);
    #else
        float rint      = stex(colortex2).y;
        bool rain       = rint > 0.0;

        if (rain) sceneHDR = mix(sceneHDR, sceneHDR * 1.4, rint * 0.5);
    #endif

    #ifndef DIM
    #ifdef legacyFlareToggle
        sceneHDR   += getLensflare();
    #endif
    #endif

    #ifdef manualExposureEnabled
        sceneHDR   *= rcp(manualExposureValue);
    #else
        sceneHDR   *= stex(colortex4).a;
    #endif

    #if DIM == -1
        sceneHDR  *= 0.4;
    #elif DIM == 1
        sceneHDR  *= 1.0;
    #endif

    #ifdef do_colorgrading
        sceneHDR    = vibranceSaturation(sceneHDR);
        sceneHDR    = rgbLuma(sceneHDR);
    #endif

    #ifdef vignetteEnabled
        sceneHDR    = vignette(sceneHDR);
    #endif

    vec3 sceneLDR   = ACES_AP1_SRGB(sceneHDR);

    #if DEBUG_VIEW==5
        sceneLDR    = sqrt(sceneHDR);
    #endif

    #ifdef do_colorgrading
        sceneLDR    = brightnessContrast(sceneLDR);
        sceneLDR    = applyGammaCurve(sceneLDR);
    #endif

    sceneGraded     = clamp16F(sceneLDR);
}